#Bibliotheken einbinden
import pymysql
import RPi.GPIO as GPIO
import time
import json
import rel
import websocket


#GPIO Modus (BOARD / BCM)
GPIO.setmode(GPIO.BCM)

#Warnungen ausschalten
GPIO.setwarnings(False)

#GPIO Pin Belegung
ROT = 4
GELB = 17
GRUEN = 27
TASTER = 22


#Richtung der GPIO-Pins festlegen (IN / OUT)
GPIO.setup(ROT, GPIO.OUT) #rot
GPIO.setup(GELB, GPIO.OUT) #gelb
GPIO.setup(GRUEN, GPIO.OUT) #gruen
GPIO.setup(TASTER, GPIO.IN) #Taster

# In die Database verbinden.
connection = pymysql.connect(host='xxx.xxx.xxx.xxx',
                             user='datenbankuser',
                             password='datenbankpaswot',
                             db='datenbankname',
                             charset='utf8mb4',
                             cursorclass=pymysql.cursors.DictCursor)
print ("connect successful!!")



#In die DB  Tabelle einfügen
def einfuegen(rot,gelb,gruen,taster):
#     try:
          cursor=connection.cursor()
          sqlPhase =  "Insert into ispx_Ampel (ROT, GELB, GRUEN, TASTER) values (%s, %s, %s, %s)"
          # sql implementieren und 3 Parameter anweisen
          cursor.execute(sqlPhase,(rot,gelb,gruen,taster))
          connection.commit()
#    finally:
          # Die Verbindung schließen (Close connection).
          # connection.close()

#Websockets
def on_error(ws, error):
    print(error)

def on_close(ws, close_status_code, close_msg):
    print("### closed ###")
def on_open(ws):
    print("Opened connection")

def on_message(ws, message):
    #data = json.loads(message)
    cursor = connection.cursor()
    cursor.execute("SELECT * FROM ispx_Ampel ORDER BY ID DESC LIMIT 1")
    for row in cursor:
       print(row)
    umschalten()

if __name__ == "__main__":
    websocket.enableTrace(True)
    ws = websocket.WebSocketApp("wss://idea.spastronix.com:3000", on_open=on_open, on_message=on_message, on_error=on_error, on_close=on_close)
    ws.run_forever(dispatcher=rel)  # Set dispatcher to automatic reconnection, 5 second re>
    rel.signal(2, rel.abort)  # Keyboard Interrupt
    rel.dispatch()


#Umschaltung definieren
def umschalten():
    #Phase 2
    GPIO.output(ROT, True)
    GPIO.output(GELB, True)
    GPIO.output(GRUEN, False)
    einfuegen(1,1,0,0)
    event = {
            "Rot": 1,
            "Gelb": 1,
            "Gruen": 0,
            "Taster": 0,
        }
    ws.send(json.dumps(event))
    time.sleep(2)
    #Phase 3
    GPIO.output(GRUEN, True)
    GPIO.output(ROT, False)
    GPIO.output(GELB, False)
    einfuegen(0,0,1,0)
    event = {
            "Rot": 0,
            "Gelb": 0,
            "Gruen": 1,
            "Taster": 0,
        }
    ws.send(json.dumps(event))
    time.sleep(15)
    #Phase 4
    GPIO.output(GELB, True)
    GPIO.output(GRUEN, False)
    einfuegen(0,1,0,0)
    event = {
event = {
            "Rot": 0,
            "Gelb": 1,
            "Gruen": 0,
            "Taster": 0,
        }
    ws.send(json.dumps(event))
    time.sleep(3)
    #zurueck zu Phase 1
    GPIO.output(ROT, True)
    GPIO.output(GELB, False)
    einfuegen(1,0,0,0)
    event = {
            "Rot": 1,
            "Gelb": 0,
            "Gruen": 0,
            "Taster": 0,
        }
    ws.send(json.dumps(event))

#Endlosschleife
while True:
    #Phase 1
    GPIO.output(ROT, True)
    GPIO.output(GELB, False)
    GPIO.output(GRUEN, False)

    #Status des Tasters einlesen
    tasterStatus = GPIO.input(TASTER)
    if (tasterStatus):
        on_message(ws, "hallo")
umschalten()



